import { requireAdmin, adminError } from "@/lib/admin";
import { listInvites } from "@/lib/store";
import { inviteUrl } from "@/lib/links";

export async function GET(req, { params }) {
  if (!requireAdmin(req)) return adminError();
  const invites = await listInvites(params.eventId);
  const withLinks = invites.map(i => ({ ...i, link: inviteUrl(i.token) }));
  return new Response(JSON.stringify({ invites: withLinks }), { headers: { "content-type": "application/json" } });
}
